#ifndef EX94421ADEMO_H
#define EX94421ADEMO_H

#include <QMainWindow>
#include <QPalette>
#include <QColor>
#include <QMessageBox>
#include <QCloseEvent>
#include <QComboBox>

#include "ttl_io_form.h"
#include "tc_form.h"
#include "interrupt_form.h"


namespace Ui {
    class ex94421ademo;
}

class ex94421ademo : public QMainWindow
{
    Q_OBJECT

public:
    explicit ex94421ademo(QWidget *parent = 0);
    ~ex94421ademo();
    // sub fuction:
    void initial_card();
    void check_card();
    void ad_config_update();
    void ad_config_set();
    void ad_read();
    void change_data_to_voltage(u8,u16,f64*);

private slots:
    void on_StartStop_pushButton_toggled(bool checked);

    void on_Exit_pushButton_clicked();

    void on_CardID_comboBox_currentIndexChanged(int index);


    void on_actionExit_triggered();

    void on_actionIO_triggered();

    void on_actionTC_triggered();

    void on_actionInterrupt_triggered();

    void on_AdMode_comboBox_currentIndexChanged(int index);

protected:
      void timerEvent ( QTimerEvent *event);
      void closeEvent ( QCloseEvent *event );
//  void showEvent ( QShowEvent * );
//  void paintEvent ( QPaintEvent *);

public:
      int main_timer;
      u8 ad_config[8];
      bool initial_failed;
      int close_timer;

private:
    Ui::ex94421ademo *ui;
    TTL_IO_Form *form_TTL_IO;
    TC_Form *form_TC;
    Interrupt_Form *form_Interrupt;

    // Object array
    QComboBox *AD_config_comboBox[8];
    QLineEdit *AD_value_lineEdit[8];
};

#endif // EX94421ADEMO_H

